/***************************************************************************************************
 * File name:PortIO.m
 * Function:To realize connect and communicate to WIFI
 * Version:V1.0 Time:2013.08 Record:Encoding and debugging for the first time
 ***************************************************************************************************///

#import <Foundation/Foundation.h>
#import "ErrorCode.h"
#import <CoreBluetooth/CoreBluetooth.h>
#import <ExternalAccessory/ExternalAccessory.h>

#define ANDREW 201509

typedef enum PortType
{
    PORT_TYPE_WIFI = 1,
    PORT_TYPE_BluetoothBLE,
    PORT_TYPE_BLUEtoothMFI
}PortType;

@interface PortIO : NSObject
{
    SInt32	ConnectSuccessFlag;
}

@property (readonly, nonatomic)     PortType portType;
@property (nonatomic, readwrite)    SInt32	ConnectSuccessFlag;

/***************************************************************************************************
 * 函数功能:搜索打印机并返回搜索到的打印机信息列表
 * 参数列表:无
 * 返回值:nil 失败； 否则 返回搜索的打印机信息列表
 ***************************************************************************************************/
- (NSMutableArray*)searchPort;

/***************************************************************************************************
 * function:Create connection software and printer according to IP address
 * Param list: DeviceName:	[in] IP address of printer
 *             TimeOut:		[in] the timeout of creating connection(ms)
 * return：Procrssing was success -- SUCCESS
 *         Could not execute process -- ERR_PROCESSING
 **************************************************************************************************/
- (SInt32)openPort:(NSString*)DeviceName TimeOut:(SInt32)TimeOut;
- (SInt32)openPort:(NSString *)advName;
- (SInt32)openPort:(EAAccessory*)accessory protocolString:(NSString*)protocolString;

/***************************************************************************************************
 * function:Close port
 * Param list: none
 * return：Procrssing was success -- SUCCESS
 *         Could not execute process -- ERR_PROCESSING
 **************************************************************************************************/
- (SInt32)closePort;

/***************************************************************************************************
 * function:Write data to port
 * Param list: WriteBuffer:	[in] The sending data buffer.It stores data to be sent
 *             OffsetSize:	[in] Specify the offset value from the top of WriteBuffer
 *             WriteSize:	[in] the number of bytes that would be sent
 *             WriteTimeOut:[in] the timeout of writing data (ms)
 the number of bytes be wrote-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)writePort:(const UInt8*)WriteBuffer OffsetSize:(SInt32)OffsetSize WriteSize:(SInt32)WriteSize WriteTimeOut:(SInt32)WriteTimeOut;

/***************************************************************************************************
 * function:Write data to port
 * Param list: WriteBuffer:	[in] The sending data buffer.It stores data to be sent
 *             OffsetSize:	[in] Specify the offset value from the top of WriteBuffer
 *             WriteSize:	[in] the number of bytes that would be sent
 *             WriteTimeOut:[in] the timeout of writing data (ms)
 *             PortID:      [in] the ID of port
 * return：the number of bytes wrote-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)writePort:(const UInt8*)WriteBuffer OffsetSize:(SInt32)OffsetSize WriteSize:(SInt32)WriteSize WriteTimeOut:(SInt32)WriteTimeOut PortID:(SInt32)PortID;

/***************************************************************************************************
 * function:Read data from port
 * Param list: ReadBuffer:	[in] The receiving data buffer for storing received data. 
 *             OffsetSize:	[in] Specify the offset value from the top of ReadBuffer.
 *             ReadSize:	[in] the number of bytes which would be received
 *             ReadTimeOut: [in] the timeout of receiving data (ms)
 * return： the number of bytes read-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)readPort:(UInt8*)ReadBuffer OffsetSize:(SInt32)OffsetSize ReadSize:(SInt32)ReadSize ReadTimeOut:(SInt32)ReadTimeOut;

- (NSData*)readPort:(SInt32)timeOut startSign:(NSData*)startSign endSign:(NSData*)endSign;
- (NSData*)readPort:(SInt32)timeOut portID:(SInt32)portID startSign:(NSData*)startSign endSign:(NSData*)endSign;

/***************************************************************************************************
 * function:Read data from port
 * Param list: ReadBuffer:	[in] The receiving data buffer for storing received data.
 *             OffsetSize:	[in] Specify the offset value from the top of ReadBuffer.
 *             ReadSize:	[in] the number of bytes which would be read
 *             ReadTimeOut: [in] the timeout of receiving data (ms)
 *             PortID:      [in] the ID of port
 * return： the number of bytes read-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)readPort:(UInt8*)ReadBuffer OffsetSize:(SInt32)OffsetSize ReadSize:(SInt32)ReadSize ReadTimeOut:(SInt32)ReadTimeOut PortID:(SInt32)PortID;

/***************************************************************************************************
 * function:Record communication data
 * Param list: recordFileName:	[in] the file name recorded
 * return： the number of bytes read-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)recordCommunicationDataEnable:(NSString*)recordFileName;

/***************************************************************************************************
 * function:Record communication data
 * Param list: Data:	[in] the communication data would be record 
 *             Length:	[in] the length of communication data
 * return： the number of bytes read-- Positive value
 *          fail -- Negative value
 **************************************************************************************************/
- (SInt32)recordCommunicationData:(NSString*)msg Data:(const UInt8*)Data Length:(SInt32)Length;

/***************************************************************************************************
 * function:Scan for BlueTooth peripherals
 * return：The information of peripherals
 **************************************************************************************************/
- (NSMutableArray*)scan;

/***************************************************************************************************
 * function:Connect BlueTooth peripherals
 * Param list: Peripheral:The <code>CBPeripheral</code> to be connected.
 *             advName:The name of BlueTooth peripheral
 * return：Procrssing was success -- SUCCESS
 *         Could not execute process -- ERR_INVALID_CONNECTION
 **************************************************************************************************/
- (SInt32)connectDevice:(CBPeripheral *)myPeripheral advName:(NSString *)advName;

/***************************************************************************************************
 * function:This cancels any subscriptions if there are any, or straight disconnects if not.
 * Param list: Peripheral:The connected CBPeripheral will be disconnected.
 * return：Procrssing was success -- SUCCESS
 *         Could not execute process -- ERR_INVALID_CONNECTION
 **************************************************************************************************/
- (SInt32)disconnect:(CBPeripheral *)Peripheral;


/***************************************************************************************************
 * function:Select write data type. If you select CBCharacteristicWriteWithoutResponse, please set sleep time.
 * Param list: WriteType: CBCharacteristicWriteWithoutResponse/CBCharacteristicWriteWithResponse. If you select CBCharacteristicWriteWithoutResponse, SleepTime should be more than 18.
 * return：Procrssing was success -- SUCCESS
 *        Invalid parameter was passed -- ERR_INVALID_ARGUMENT
 **************************************************************************************************/
- (SInt32)setWriteType:(CBCharacteristicWriteType)WriteType SleepTime:(SInt32)SleepTime;

- (UInt64)getTickCount;

@end





